﻿var m_OperMenuJson = [];//当前查询数据缓存
var m_select = 0;//0代表选择饼状图，1代表选择柱状图

// 好友数量统计页面加载
$(function () {
	$("#myPageAlert").hide();
	listcss();
	dataObj.getintegratedalysis();
});

//图形显示数据回调
function AsyncGetIntegratedAlysisResult(jsonResult) {
	$("#dataselect").show();
	if (jsonResult.success) {
		m_OperMenuJson = jsonResult.result;
		if (typeof (m_OperMenuJson.list) != "undefined" && m_OperMenuJson.list.length > 0) {
			if (1 == m_select) {
				BargraphShow(); //柱状图显示
			} else {
				PiechartShow(); //饼状图显示
				$("#friendcount").html(m_OperMenuJson.list[0].totalfriend); //获取好友总数
				$("#man").html(m_OperMenuJson.list[0].nan); //获取男好友数
				$("#woman").html(m_OperMenuJson.list[0].nv); //获取女好友数
				$("#unknown").html(m_OperMenuJson.list[0].unknown); //获取未知好友数
				$("#divmancount").show(); //男好友数据显示
				$("#divwomancount").show(); //女好友数据显示
				$("#divunknowncount").show(); //未知好友数据显示
				$("#divfriendcount").show(); //好友总数数据显示
			}
		}
		else {
			$("#main").html("暂无数据");
		}
	} else {
		ShowError("myPageAlert", "获取数据异常：" + jsonResult.error);
	}
	$(".loading").hide();
	$(".historyzhezhao").hide();
	$(".loadingcover").hide();
	$(".loading").hide();
}
//饼状图点击事件
function PiechartClick() {
	m_select = 0;
	if (typeof (m_OperMenuJson.list) != "undefined" && m_OperMenuJson.list.length > 0) {
		PiechartShow();//饼状图生成
		$("#friendcount").html(m_OperMenuJson.list[0].totalfriend); //获取好友总数
		$("#man").html(m_OperMenuJson.list[0].nan); //获取男好友数
		$("#woman").html(m_OperMenuJson.list[0].nv);//获取女好友数
		$("#unknown").html(m_OperMenuJson.list[0].unknown); //获取未知好友数
		$("#divmancount").show(); //男好友数据显示
		$("#divwomancount").show();//女好友数据显示
		$("#divunknowncount").show(); //未知好友数据显示
		$("#divyesterdayfriendcount").hide(); //昨日新增隐藏
		$("#divtodaynewfriendcount").hide(); //今日新增隐藏
		$("#divfriendcount").show(); //好友总数显示
	} else {
		$("#main").html("暂无数据");
	}
}
//柱状图点击事件
function BargraphClick() {
	m_select = 1;
	if (typeof (m_OperMenuJson.list) != "undefined" && m_OperMenuJson.list.length > 0) {
		BargraphShow();//柱状图生成
		$("#todaynewfriend").html(m_OperMenuJson.list[0].todaynewfriend); //获取今日新增好友数据
		$("#yesterdayfriend").html(m_OperMenuJson.list[0].yestodaynewfriend); //获取昨日新增好友数据
		$("#divmancount").hide(); //男好友数据隐藏
		$("#divwomancount").hide(); //女好友数据隐藏
		$("#divunknowncount").hide(); //未知好友数据隐藏
		$("#divyesterdayfriendcount").show(); //昨日新增好友数据显示
		$("#divtodaynewfriendcount").show(); //今日新增好友数据显示
		$("#divfriendcount").hide(); //好友总数数据隐藏
	} else {
		$("#main").html("暂无数据");
	}

}

//柱状图生成
function BargraphShow() {
	var data = [];
	var chinese = ["今日新增", "昨日新增"];
	var todayfriend = Number(m_OperMenuJson.list[0].todaynewfriend);
	var yestodayfriend = Number(m_OperMenuJson.list[0].yestodaynewfriend);
	data.push(todayfriend);
	data.push(yestodayfriend);
	var myChart = echarts.init(document.getElementById('main'));

	// 指定图表的配置项和数据
	var option = {
		title: {
			text: '新增好友'
		},
		tooltip: {
			trigger: 'axis',
			axisPointer: {            // 坐标轴指示器，坐标轴触发有效
				type: 'shadow'        // 默认为直线，可选为：'line' | 'shadow'
			}
		},
		grid: {
			left: '0',
			right: '0',
			containLabel: true
		},
		xAxis: {
			data: chinese
		},
		yAxis: {},
		series: [{
			name: '好友数量',
			barWidth: '50%',
			type: 'bar',
			data: data,
			itemStyle: {
				normal: { color: '#61BCE8' }
			}
		}],

	};
	// 使用刚指定的配置项和数据显示图表。
	myChart.setOption(option);

}


//饼状图生成
function PiechartShow() {
	var man = Number(m_OperMenuJson.list[0].nan);
	var woman = Number(m_OperMenuJson.list[0].nv);
	var unknown = Number(m_OperMenuJson.list[0].unknown);

	var myChart = echarts.init(document.getElementById('main'));

	// 指定图表的配置项和数据
	var option = {
		title: {
			text: '男女比例',
			//subtext: '纯属虚构',
			x: 'center'
		},
		tooltip: {
			trigger: 'item',
			formatter: "{a} <br/>{b} : {c} ({d}%)"
		},
		legend: {
			orient: 'vertical',
			left: 'left',
			data: ['男', '女', '未知']
		},
		series: [
			{
				name: '饼状图',
				type: 'pie',
				radius: '70%',
				center: ['50%', '60%'],
				data: [
					{ value: man, name: '男' },
					{ value: woman, name: '女' },
					{ value: unknown, name: '未知' },
				],
				itemStyle: {
					emphasis: {
						shadowBlur: 10,
						shadowOffsetX: 0,
						shadowColor: 'rgba(0, 0, 0, 0.5)'
					}
				}
			}
		]
	};
	// 使用刚指定的配置项和数据显示图表。
	myChart.setOption(option);
}
//}
//样式操作
function listcss() {
	$("#right").css({
		height: $(window).height()
	});
	$("#left").css({
		height: $(window).height()
	});
	$(".left-list-l").css({
		height: $(window).height()
	});
	$(".friends-table").css({
		height: $(window).height() - 180
	});
}
$(window).resize(function () {
	listcss();
});
